<?php
function get_esxi_datastore_mapping( $argv ) {

    try {
    
        // check number of arguments
        if( count( $argv ) != 3 ) {
            throw new Exception( "Usage: get_esxi_datastore_mapping <EsxiHost> <EsxiUsername> <EsxiPassword>\n" ) ;
        }
        
        // fetch arguments
        $esxi_host     = $argv[ 0 ] ;
        $esxi_username = $argv[ 1 ] ;
        $esxi_password = $argv[ 2 ] ;
        
        // get datastorename
        debug_print( "QueryEsxiDatastoreName" ) ;
        $ret_array = run_program_at_esxi_by_ssh( array(
            'esxi_ip'       => $esxi_host,
            'esxi_username' => $esxi_username,
            'esxi_password' => $esxi_password,
            
            'program'   => '/bin/find',
            'arguments' => array(
                "/vmfs/volumes",
                "-maxdepth", "1",
                "-type", "l"
        ) ) ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( ",", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "QueryEsxiDatastoreNameFail: ret='$retCode', stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "QueryEsxiDatastoreNameSuccess: '$stdoutMsg'" ) ;
        $dsNameArray = $stdoutMsgAry ;
        # var_dump( $dsNameArray ) ;        
        
        // get corresponding uuid
        $dsUuidArray = array() ;
        foreach( $dsNameArray as $dsPath ) {
            
            debug_print( "QueryEsxiDatastoreUuid: dsPath='$dsPath'" ) ;
            $ret_array = run_program_at_esxi_by_ssh( array(
                'esxi_ip'       => $esxi_host,
                'esxi_username' => $esxi_username,
                'esxi_password' => $esxi_password,
                
                'program'   => "cd '$dsPath'; pwd -P"
            ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "QueryEsxiDatastoreUuidFail: ret='$retCode', stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            debug_print( "QueryEsxiDatastoreUuidSuccess: '$stdoutMsg'" ) ;
            
            array_push( $dsUuidArray, $stdoutMsg ) ;
        }
        # var_dump( $dsUuidArray ) ;
        
        // combine dsName and dsUuid, "<DsName1>=<DsUuid1>,<DsName2>=<DsUuid2>,..."
        $result = "" ;
        foreach( $dsNameArray as $index => $dsPath ) {
            $mapping = '"' . basename( $dsPath ) . '=' . basename( $dsUuidArray[ $index ] ) . '"' ;
            ( $result == "" ) ? $result = $mapping : $result = "${result} ${mapping}" ;
        }
        # var_dump( $result ) ;
        
        echo "$result" . "\n" ;
        exit( 0 ) ;
	}
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        
        debug_print( "Exception caught: $msg" ) ;
        echo $msg . "\n" ;
        
        exit( 1 ) ;
    }
}

